unit link;

interface

uses stdctrls,controls,classes,forms,graphics,shellapi,windows,dialogs;

type
    TLink_base = class(TCustomLabel)
           protected
                 FAddress :string;

                 //mod
                 FDescription :String;
                 FInactiveColor :TColor;
	         FActiveColor :TColor;

                 procedure ChangeColorActive(Sender :TObject;Button :TmouseButton;Shift :Classes.TShiftState;X :Integer;Y :Integer);
                 procedure ChangeColorInactive(Sender :TObject;Button :TmouseButton;Shift :Classes.TShiftState;X :Integer;Y :Integer);
                 procedure CheckAddress(_URL :string); virtual; abstract;

                 //mod
                 procedure SetColor(AColor :TColor);
                 procedure SetDescription(ADescription :String);
           public
                 constructor Create(Owner :TComponent); override;
                 procedure Connect(Sender :TObject);
           published
                 property Address :string read FAddress write CheckAddress nodefault;

           	//mod
                property Description :String read FDescription write SetDescription nodefault;
                property InactiveColor :TColor read FInactiveColor write SetColor nodefault;
                property ActiveColor :TColor read FActiveColor write FActiveColor nodefault;

                property Align;
                property Enabled;
                property Font;
                property Transparent;
                property Visible;
           end;


    TLink = class(TLink_base)
           private
	         procedure CheckAddress(_URL :string); override;
           public
                 constructor Create(Owner :TComponent); override;
           end;


    TMail = class(TLink_base)
           private
	         procedure CheckAddress(_Address :string); override;
           public
                 constructor Create(Owner :TComponent); override;
           end;

    procedure Register; //ta procedura obsluguje rejestrowanie komponentow

implementation

constructor TLink_base.Create(Owner :TComponent);
var LinkStyle :TFontStyles; //zbior
begin
Inherited Create(Owner);
LinkStyle:=[fsUnderline];
Font.Color:=clNavy;
Font.Style:=LinkStyle;
OnClick:=Connect;
OnMouseDown:=ChangeColorActive;
OnMouseUp:=ChangeColorInactive;

//mod
ShowAccelChar:=false;
WordWrap:=false;
FInactiveColor:=clNavy;
FActiveColor:=clBlack;
end;

procedure TLink_base.Connect(Sender :TObject);
begin
ShellExecute(0,'open',PCHar(Address),'','',SW_NORMAL);
end;

procedure TLink_base.ChangeColorActive(Sender :TObject;Button :TmouseButton;Shift :Classes.TShiftState;X :Integer;Y :Integer);
begin
Font.Color:=FActiveColor;
end;

procedure TLink_base.ChangeColorInactive(Sender :TObject;Button :TmouseButton;Shift :Classes.TShiftState;X :Integer;Y :Integer);
begin
Font.Color:=FInactiveColor;
end;

procedure TLink_base.SetColor(AColor :TColor);
begin
FInactiveColor:=AColor;
Font.Color:=FInactiveColor;
end;

procedure TLink_base.SetDescription(ADescription :String);
begin
FDescription:=ADescription;
Caption:=FDescription;
end;


//------------------------------------------------------------------------

constructor TLink.Create(Owner :TComponent);
begin
Inherited Create(Owner);
Description:='http://www.phys.uni.torun.pl/~jacek';
FAddress:=Description;
Hint:='Link to '+Address;
ShowHint:=true;
end;

procedure TLink.CheckAddress(_URL :string);
begin
if Copy(_URL,1,7)<>'http://' then _URL:='http://'+_URL;
FAddress:=_URL;
end;

//------------------------------------------------------------------------

constructor TMail.Create(Owner :TComponent);
begin
Inherited Create(Owner);
Description:='jacek@phys.uni.torun.pl';
Address:='mailto:'+Description;
Hint:='Send a message to '+Description;
ShowHint:=true;
end;

procedure TMail.CheckAddress(_Address :string);
var hash,i :Integer;
begin
if Copy(_Address,1,7)<>'mailto:' then
   begin
   _Address:='mailto:'+_Address;
   FAddress:=_Address;
   end;

hash:=0;
for i:=0 to Length(_Address) do
    if _Address[i]='@' then hash:=i;
if hash=0 then ShowMessage('E-mail adress should include "@".') else FAddress:=_Address;
end;

//------------------------------------------------------------------------

procedure Register;
begin
RegisterComponents('JM', [TLink,TMail]);
end;

end.
